/*
 * Decompiled with CFR 0.152.
 */
import BAUM.Node;
import BAUM.Tree;
import EINGABE.eingabe;
import PERIODENSYSTEM.Isotops;
import PERIODENSYSTEM.PerSys;
import com.sun.image.codec.jpeg.ImageFormatException;
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.AWTException;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.HierarchyBoundsListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;

public class MAIN
extends JFrame {
    public PerSys per;
    private Color hintergrund;
    private Color achsen;
    private Color werte;
    private Color balken;
    private Color copyright;
    private Color hintergrund_highlight;
    private Color verb_name;
    private boolean correct;
    private boolean info;
    private Node[] final_values;
    private double min_weight;
    private double max_weight;
    private double max_percent;
    private JTextArea A_AUSGABE;
    private JButton B_ALLISOS;
    private JButton B_BERECHNE;
    private JButton B_COPY;
    private JButton B_INFO;
    private JButton B_SAVE;
    private JCheckBox C_100;
    private JCheckBox C_LABEL;
    private JCheckBox C_RESOLUTION;
    private JCheckBox C_VERB_ANZ;
    private JTextField F_EINGABE;
    private JTextField F_VERB_ANZ;
    private JTabbedPane IsotopenBerechnung;
    private JSeparator LINE1;
    private JSeparator LINE2;
    private JLabel L_1;
    private JLabel L_2;
    private JLabel L_3;
    private JLabel L_4;
    private JLabel L_5;
    private JLabel L_6;
    private JScrollPane SCROLLING;
    private JPanel TAB;

    public MAIN() {
        this.initComponents();
        this.setListener();
        this.install();
        this.repaint();
    }

    private void initComponents() {
        this.IsotopenBerechnung = new JTabbedPane();
        this.TAB = new JPanel();
        this.L_1 = new JLabel();
        this.F_EINGABE = new JTextField();
        this.B_BERECHNE = new JButton();
        this.B_ALLISOS = new JButton();
        this.B_INFO = new JButton();
        this.LINE1 = new JSeparator();
        this.L_2 = new JLabel();
        this.SCROLLING = new JScrollPane();
        this.A_AUSGABE = new JTextArea();
        this.C_LABEL = new JCheckBox();
        this.C_100 = new JCheckBox();
        this.C_VERB_ANZ = new JCheckBox();
        this.L_3 = new JLabel();
        this.F_VERB_ANZ = new JTextField();
        this.C_RESOLUTION = new JCheckBox();
        this.B_SAVE = new JButton();
        this.B_COPY = new JButton();
        this.L_4 = new JLabel();
        this.L_5 = new JLabel();
        this.L_6 = new JLabel();
        this.LINE2 = new JSeparator();
        this.setDefaultCloseOperation(3);
        this.L_1.setText("Verbindung eingeben:");
        this.B_BERECHNE.setText("Berechne");
        this.B_ALLISOS.setText("Alle Isotopen");
        this.B_INFO.setText("Info");
        this.L_2.setText("Isotopen der Verbindung:");
        this.A_AUSGABE.setColumns(20);
        this.A_AUSGABE.setRows(5);
        this.SCROLLING.setViewportView(this.A_AUSGABE);
        this.C_LABEL.setText("Labels anzeigen");
        this.C_LABEL.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.C_LABEL.setMargin(new Insets(0, 0, 0, 0));
        this.C_100.setText("auf 100% rechnen");
        this.C_100.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.C_100.setMargin(new Insets(0, 0, 0, 0));
        this.C_VERB_ANZ.setText("Verbindung in der Grafik anzeigen");
        this.C_VERB_ANZ.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.C_VERB_ANZ.setMargin(new Insets(0, 0, 0, 0));
        this.L_3.setText("Alternativer Name:");
        this.C_RESOLUTION.setText("Hohe Aufl\u00f6sung");
        this.C_RESOLUTION.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.C_RESOLUTION.setMargin(new Insets(0, 0, 0, 0));
        this.B_SAVE.setText("Grafik speichern");
        this.B_COPY.setText("Tabelle kopieren");
        this.L_4.setText("Grafisch:");
        this.L_5.setText("Status:");
        GroupLayout TABLayout = new GroupLayout(this.TAB);
        this.TAB.setLayout(TABLayout);
        TABLayout.setHorizontalGroup(TABLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(TABLayout.createSequentialGroup().addContainerGap().addGroup(TABLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.LINE2, -1, 861, Short.MAX_VALUE).addComponent(this.L_1, GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.LEADING, TABLayout.createSequentialGroup().addComponent(this.F_EINGABE, -2, 382, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.B_BERECHNE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.B_ALLISOS).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.B_INFO)).addComponent(this.LINE1, GroupLayout.Alignment.LEADING, -1, 861, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, TABLayout.createSequentialGroup().addGap(10, 10, 10).addGroup(TABLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(TABLayout.createSequentialGroup().addComponent(this.L_5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.L_6)).addGroup(TABLayout.createSequentialGroup().addComponent(this.SCROLLING, -2, 231, -2).addGap(87, 87, 87).addGroup(TABLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.C_100).addComponent(this.C_LABEL).addComponent(this.C_VERB_ANZ).addGroup(TABLayout.createSequentialGroup().addGap(17, 17, 17).addComponent(this.L_3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.F_VERB_ANZ, -2, 210, -2)).addComponent(this.C_RESOLUTION).addGroup(TABLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.B_SAVE, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.B_COPY, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)))).addComponent(this.L_2).addComponent(this.L_4)).addGap(211, 211, 211))).addContainerGap()));
        TABLayout.setVerticalGroup(TABLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(TABLayout.createSequentialGroup().addContainerGap().addComponent(this.L_1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(TABLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.F_EINGABE, -2, -1, -2).addComponent(this.B_BERECHNE).addComponent(this.B_ALLISOS).addComponent(this.B_INFO)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.LINE1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.L_2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(TABLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(TABLayout.createSequentialGroup().addComponent(this.C_LABEL).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.C_100).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.C_VERB_ANZ).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(TABLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.L_3).addComponent(this.F_VERB_ANZ, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.C_RESOLUTION).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.B_COPY).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.B_SAVE)).addComponent(this.SCROLLING, -2, 201, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 31, Short.MAX_VALUE).addComponent(this.L_4).addGap(301, 301, 301).addComponent(this.LINE2, -2, 10, -2).addGroup(TABLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(TABLayout.createSequentialGroup().addGap(4, 4, 4).addComponent(this.L_5)).addGroup(TABLayout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.L_6, -1, 12, Short.MAX_VALUE))).addContainerGap()));
        this.IsotopenBerechnung.addTab("IsotopenBerechnung", this.TAB);
        this.IsotopenBerechnung.getAccessibleContext().setAccessibleName("IsotopenBerechnung");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.IsotopenBerechnung, -1, 886, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.IsotopenBerechnung, -1, 710, Short.MAX_VALUE).addContainerGap()));
        this.pack();
    }

    private void setListener() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent evt) {
                MAIN.this.repaint();
            }
        });
        this.addHierarchyBoundsListener(new HierarchyBoundsListener(){

            @Override
            public void ancestorMoved(HierarchyEvent evt) {
                MAIN.this.repaint();
            }

            @Override
            public void ancestorResized(HierarchyEvent evt) {
                MAIN.this.repaint();
            }
        });
        this.B_BERECHNE.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                MAIN.this.rechne();
            }
        });
        this.B_INFO.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                MAIN.this.info = true;
                MAIN.this.A_AUSGABE.setText("Eingabe muss case senitive erfolgen\n\nDie Grafik wird im aktuellen\nVerzeichnis gespeichert!\n\n\nweitere Informationen unter\nwww.iso2l.de.vu");
                MAIN.this.L_6.setText("Gib eine Verbindung ein und klicke Berechnen!                  ");
                MAIN.this.repaint();
            }
        });
        this.B_ALLISOS.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                MAIN.this.info = true;
                String ausgabe = "";
                for (int j = 1; j < MAIN.this.per.elemente.length; ++j) {
                    Isotops[] Li = MAIN.this.per.elemente[j].isos.gib_isos();
                    int laenge = Li.length;
                    ausgabe = ausgabe + "\n" + MAIN.this.per.elemente[j].name + "\n";
                    for (int k = 0; k < laenge; ++k) {
                        ausgabe = ausgabe + "Prozent " + Li[k].percent;
                        ausgabe = ausgabe + ", Gewicht " + Li[k].weight + "\n";
                    }
                }
                MAIN.this.A_AUSGABE.setText(ausgabe);
                MAIN.this.correct = false;
                MAIN.this.L_6.setText("Gib eine Verbindung ein und klicke Berechnen!                  ");
                MAIN.this.repaint();
            }
        });
        this.B_COPY.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                StringSelection text = new StringSelection(MAIN.this.A_AUSGABE.getText());
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(text, null);
            }
        });
        this.B_SAVE.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                try {
                    BufferedImage screenshot = new Robot().createScreenCapture(new Rectangle(MAIN.this.getLocation().x + 50, MAIN.this.getLocation().y + 400, 700, 270));
                    BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream("iso2l_Grafik.jpg"));
                    JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder((OutputStream)out);
                    encoder.encode(screenshot);
                    out.close();
                }
                catch (AWTException ex) {
                    MAIN.this.A_AUSGABE.setText(ex.toString());
                }
                catch (FileNotFoundException ex) {
                    MAIN.this.A_AUSGABE.setText(ex.toString());
                }
                catch (ImageFormatException ex) {
                    MAIN.this.A_AUSGABE.setText(ex.toString());
                }
                catch (IOException ex) {
                    MAIN.this.A_AUSGABE.setText(ex.toString());
                }
            }
        });
        this.F_EINGABE.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    MAIN.this.rechne();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }
        });
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new MAIN().setVisible(true);
            }
        });
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        g.setColor(this.hintergrund);
        g.fillRect(50, 400, 700, 270);
        if (this.info) {
            g.setColor(new Color(40, 70, 255));
            Font schrift = new Font("Arial", 1, 30);
            g.setFont(schrift);
            g.drawString("Das IsotopenBerechnungsTool!", 120, 500);
            g.setColor(new Color(90, 120, 255));
            schrift = new Font("Arial", 1, 14);
            g.setFont(schrift);
            g.drawString("Entwickler:", 200, 550);
            g.drawString("Martin Scharm", 210, 565);
            g.drawString("Christoph Ruttkies", 210, 580);
            g.drawString("Steffi Dornfeldt", 210, 595);
            g.drawString("f\u00fcr weitere Informationen", 410, 550);
            g.drawString("und Updates:", 410, 565);
            g.setColor(new Color(80, 100, 245));
            schrift = new Font("Arial", 1, 14);
            g.drawString("www.iso2l.de.vu", 450, 580);
        } else if (!this.correct) {
            g.setColor(this.balken);
            Font schrift = new Font("Arial", 1, 30);
            g.setFont(schrift);
            g.drawString("Keine Korrekte Verbindung!", 200, 500);
        } else {
            int left = 105;
            int right = 705;
            int up = 440;
            int down = 640;
            g.setColor(this.hintergrund_highlight);
            g.fillRect(left, up, right - left, (down - up) / 4);
            g.fillRect(left, (up + down) / 2, right - left, (down - up) / 4);
            g.setColor(this.achsen);
            g.drawLine(left, down, right, down);
            g.drawLine(left, up, left, down);
            g.drawLine(left - 5, up, left, up);
            g.drawLine(left - 5, (up + down) / 2, left, (up + down) / 2);
            g.drawString("100%", left - 38, up + 5);
            g.drawString("50%", left - 33, (up + down) / 2 + 5);
            int bereich = right - left;
            int steps = (int)(this.max_weight - this.min_weight + 2.0);
            double steplength = bereich / steps;
            for (int i = 1; i < steps; ++i) {
                int wo = (int)((double)i * steplength + (double)left);
                g.drawLine(wo, down, wo, down + 5);
                g.drawString(Integer.toString((int)this.min_weight - 1 + i), wo - 8, down + 18);
            }
            double faktor = 1.0;
            if (this.C_100.isSelected()) {
                faktor = 100.0 / this.max_percent;
            }
            g.setColor(this.balken);
            for (int i = 0; i < this.final_values.length; ++i) {
                int wo = (int)((this.final_values[i].weight - this.min_weight + 1.0) * steplength + (double)left);
                g.drawLine(wo, down, wo, up + 200 - (int)(this.final_values[i].percent * 2.0 * faktor));
                if (!this.C_LABEL.isSelected()) continue;
                g.drawString("" + this.final_values[i].weight, wo - 8, up + 196 - (int)(this.final_values[i].percent * 2.0 * faktor));
            }
            if (this.C_VERB_ANZ.isSelected()) {
                g.setColor(this.verb_name);
                Font schrift = new Font("Arial", 1, 15);
                g.setFont(schrift);
                g.setColor(this.verb_name);
                if (this.F_VERB_ANZ.getText().equals("")) {
                    g.drawString("Verbindung: " + this.F_EINGABE.getText(), 120, 420);
                } else {
                    g.drawString("Verbindung: " + this.F_VERB_ANZ.getText(), 120, 420);
                }
            }
        }
    }

    public void rechne() {
        this.info = false;
        String eingabe2 = this.F_EINGABE.getText();
        String ausgabe = "";
        eingabe in = new eingabe();
        this.L_6.setText("Eingabe wird \u00fcberpr\u00fcft!                  ");
        Vector rueckgabe = in.scan(eingabe2, this.per);
        if (rueckgabe == null) {
            ausgabe = "Falsche Eingabe!";
            this.L_6.setText("Die Eingabe ist nicht korrekt, versuchs nochmal!                  ");
            this.correct = false;
            this.repaint();
        } else {
            Tree baum = new Tree();
            this.L_6.setText("Isotopen werden berechnet!                  ");
            Vector stoffi = baum.mach_ausrechnen(rueckgabe, this.per);
            this.final_values = this.zauber(stoffi);
            this.L_6.setText("Tabelle wird erstellt!                  ");
            for (int i = 0; i < this.final_values.length; ++i) {
                ausgabe = ausgabe + "\nIsotop " + (i + 1) + "\n";
                ausgabe = ausgabe + "\nProzent: " + this.final_values[i].percent;
                ausgabe = ausgabe + "\nGewicht: " + this.final_values[i].weight;
                ausgabe = ausgabe + "\n";
            }
            this.L_6.setText("Bild wird gemalt!                  ");
            this.correct = true;
            this.repaint();
            this.L_6.setText("Fertig!                  ");
        }
        this.A_AUSGABE.setText(ausgabe);
    }

    private Node[] zauber(Vector stoffi) {
        Node[] staffi = new Node[stoffi.size()];
        this.max_weight = ((Node)stoffi.elementAt((int)0)).weight;
        this.min_weight = ((Node)stoffi.elementAt((int)0)).weight;
        this.max_percent = ((Node)stoffi.elementAt((int)0)).percent;
        for (int i = 0; i < stoffi.size(); ++i) {
            staffi[i] = new Node();
            staffi[i].percent = (double)Math.round(((Node)stoffi.elementAt((int)i)).percent * 100.0 * 100.0) / 100.0;
            staffi[i].weight = ((Node)stoffi.elementAt((int)i)).weight;
            if (!this.C_RESOLUTION.isSelected()) {
                staffi[i].weight = Math.round(staffi[i].weight);
            }
            if (staffi[i].weight > this.max_weight) {
                this.max_weight = staffi[i].weight;
            }
            if (staffi[i].weight < this.min_weight) {
                this.min_weight = staffi[i].weight;
            }
            if (!(staffi[i].percent > this.max_percent)) continue;
            this.max_percent = staffi[i].percent;
        }
        if (!this.C_RESOLUTION.isSelected()) {
            staffi = this.watch(staffi);
        }
        return staffi;
    }

    private Node[] watch(Node[] doppelte) {
        int j;
        Vector<Node> tmp = new Vector<Node>();
        boolean found = false;
        for (int i = 0; i < doppelte.length; ++i) {
            found = false;
            for (j = 0; j < tmp.size(); ++j) {
                if (((Node)tmp.elementAt((int)j)).weight != doppelte[i].weight) continue;
                ((Node)tmp.elementAt((int)j)).percent = (double)Math.round((((Node)tmp.elementAt((int)j)).percent + doppelte[i].percent) * 100.0) / 100.0;
                found = true;
                break;
            }
            if (found) continue;
            tmp.add(doppelte[i]);
        }
        Node[] stuffi = new Node[tmp.size()];
        this.max_weight = ((Node)tmp.elementAt((int)0)).weight;
        this.min_weight = ((Node)tmp.elementAt((int)0)).weight;
        this.max_percent = ((Node)tmp.elementAt((int)0)).percent;
        for (j = 0; j < tmp.size(); ++j) {
            stuffi[j] = new Node();
            stuffi[j].percent = ((Node)tmp.elementAt((int)j)).percent;
            stuffi[j].weight = ((Node)tmp.elementAt((int)j)).weight;
            if (stuffi[j].weight > this.max_weight) {
                this.max_weight = stuffi[j].weight;
            }
            if (stuffi[j].weight < this.min_weight) {
                this.min_weight = stuffi[j].weight;
            }
            if (!(stuffi[j].percent > this.max_percent)) continue;
            this.max_percent = stuffi[j].percent;
        }
        return stuffi;
    }

    private void install() {
        this.hintergrund = new Color(255, 255, 255);
        this.hintergrund_highlight = new Color(240, 240, 240);
        this.achsen = new Color(0, 0, 0);
        this.werte = new Color(0, 0, 0);
        this.balken = new Color(0, 0, 0);
        this.copyright = new Color(240, 240, 240);
        this.verb_name = new Color(0, 0, 0);
        this.correct = false;
        this.info = true;
        this.L_6.setText("Gib eine Verbindung ein und klicke Berechnen!                  ");
        this.per = new PerSys(93);
        int i = 0;
        this.per.elemente[i].elekneg = 2.1;
        this.per.elemente[i].name = "Deuterium";
        this.per.elemente[i].zeichen = "D";
        this.per.elemente[i].isos.nach_hinten(1.0, 2.014102);
        this.per.elemente[++i].elekneg = 2.1;
        this.per.elemente[i].name = "Wasserstoff";
        this.per.elemente[i].zeichen = "H";
        this.per.elemente[i].isos.nach_hinten(0.99985, 1.007825);
        this.per.elemente[i].isos.nach_hinten(1.5E-4, 2.014102);
        this.per.elemente[++i].elekneg = 0.0;
        this.per.elemente[i].name = "Helium";
        this.per.elemente[i].zeichen = "He";
        this.per.elemente[i].isos.nach_hinten(1.4E-6, 3.016029);
        this.per.elemente[i].isos.nach_hinten(0.9999986, 4.002603);
        this.per.elemente[++i].elekneg = 1.0;
        this.per.elemente[i].name = "Lithium";
        this.per.elemente[i].zeichen = "Li";
        this.per.elemente[i].isos.nach_hinten(0.0742, 6.015123);
        this.per.elemente[i].isos.nach_hinten(0.9258, 7.016005);
        this.per.elemente[++i].elekneg = 1.5;
        this.per.elemente[i].name = "Beryllium";
        this.per.elemente[i].zeichen = "Be";
        this.per.elemente[i].isos.nach_hinten(1.0, 9.012183);
        this.per.elemente[++i].elekneg = 2.0;
        this.per.elemente[i].name = "Bor";
        this.per.elemente[i].zeichen = "B";
        this.per.elemente[i].isos.nach_hinten(0.198, 10.012938);
        this.per.elemente[i].isos.nach_hinten(0.802, 11.009305);
        this.per.elemente[++i].elekneg = 2.5;
        this.per.elemente[i].name = "Kohlenstoff";
        this.per.elemente[i].zeichen = "C";
        this.per.elemente[i].isos.nach_hinten(0.989, 12.0);
        this.per.elemente[i].isos.nach_hinten(0.011, 13.003355);
        this.per.elemente[++i].elekneg = 3.0;
        this.per.elemente[i].name = "Stickstoff";
        this.per.elemente[i].zeichen = "N";
        this.per.elemente[i].isos.nach_hinten(0.9963, 14.003074);
        this.per.elemente[i].isos.nach_hinten(0.0037, 15.000109);
        this.per.elemente[++i].elekneg = 3.5;
        this.per.elemente[i].name = "Sauerstoff";
        this.per.elemente[i].zeichen = "O";
        this.per.elemente[i].isos.nach_hinten(0.99761, 15.994915);
        this.per.elemente[i].isos.nach_hinten(3.8E-4, 16.999131);
        this.per.elemente[i].isos.nach_hinten(0.00201, 17.999159);
        this.per.elemente[++i].elekneg = 4.0;
        this.per.elemente[i].name = "Fluor";
        this.per.elemente[i].zeichen = "F";
        this.per.elemente[i].isos.nach_hinten(1.0, 18.998403);
        this.per.elemente[++i].elekneg = 0.0;
        this.per.elemente[i].name = "Neon";
        this.per.elemente[i].zeichen = "Ne";
        this.per.elemente[i].isos.nach_hinten(0.906, 19.992439);
        this.per.elemente[i].isos.nach_hinten(0.0026, 20.993845);
        this.per.elemente[i].isos.nach_hinten(0.092, 21.991384);
        this.per.elemente[++i].elekneg = 0.9;
        this.per.elemente[i].name = "Natrium";
        this.per.elemente[i].zeichen = "Na";
        this.per.elemente[i].isos.nach_hinten(1.0, 22.98897);
        this.per.elemente[++i].elekneg = 1.2;
        this.per.elemente[i].name = "Magnesium";
        this.per.elemente[i].zeichen = "Mg";
        this.per.elemente[i].isos.nach_hinten(0.789, 23.985046);
        this.per.elemente[i].isos.nach_hinten(0.1, 24.985839);
        this.per.elemente[i].isos.nach_hinten(0.111, 25.982595);
        this.per.elemente[++i].elekneg = 1.5;
        this.per.elemente[i].name = "Aluminium";
        this.per.elemente[i].zeichen = "Al";
        this.per.elemente[i].isos.nach_hinten(1.0, 26.981541);
        this.per.elemente[++i].elekneg = 1.8;
        this.per.elemente[i].name = "Silicium";
        this.per.elemente[i].zeichen = "Si";
        this.per.elemente[i].isos.nach_hinten(0.9223, 27.976928);
        this.per.elemente[i].isos.nach_hinten(0.0467, 28.976496);
        this.per.elemente[i].isos.nach_hinten(0.031, 29.97377);
        this.per.elemente[++i].elekneg = 2.1;
        this.per.elemente[i].name = "Phosphor";
        this.per.elemente[i].zeichen = "P";
        this.per.elemente[i].isos.nach_hinten(1.0, 30.973763);
        this.per.elemente[++i].elekneg = 2.5;
        this.per.elemente[i].name = "Schwefel";
        this.per.elemente[i].zeichen = "S";
        this.per.elemente[i].isos.nach_hinten(0.9502, 31.972072);
        this.per.elemente[i].isos.nach_hinten(0.0075, 32.971459);
        this.per.elemente[i].isos.nach_hinten(0.0421, 33.967866);
        this.per.elemente[i].isos.nach_hinten(2.0E-4, 35.967079);
        this.per.elemente[++i].elekneg = 3.0;
        this.per.elemente[i].name = "Chlor";
        this.per.elemente[i].zeichen = "Cl";
        this.per.elemente[i].isos.nach_hinten(0.7577, 34.968853);
        this.per.elemente[i].isos.nach_hinten(0.2423, 36.965903);
        this.per.elemente[++i].elekneg = 0.0;
        this.per.elemente[i].name = "Argon";
        this.per.elemente[i].zeichen = "Ar";
        this.per.elemente[i].isos.nach_hinten(0.0034, 35.967546);
        this.per.elemente[i].isos.nach_hinten(6.3E-4, 37.962732);
        this.per.elemente[i].isos.nach_hinten(0.996, 39.962384);
        this.per.elemente[++i].elekneg = 0.8;
        this.per.elemente[i].name = "Kalium";
        this.per.elemente[i].zeichen = "K";
        this.per.elemente[i].isos.nach_hinten(0.932, 38.963708);
        this.per.elemente[i].isos.nach_hinten(1.2E-4, 39.963999);
        this.per.elemente[i].isos.nach_hinten(0.0673, 40.961825);
        this.per.elemente[++i].elekneg = 1.0;
        this.per.elemente[i].name = "Calcium";
        this.per.elemente[i].zeichen = "Ca";
        this.per.elemente[i].isos.nach_hinten(0.9695, 39.962591);
        this.per.elemente[i].isos.nach_hinten(0.0065, 41.958622);
        this.per.elemente[i].isos.nach_hinten(0.0014, 4.2958766E7);
        this.per.elemente[i].isos.nach_hinten(0.0286, 43.955485);
        this.per.elemente[i].isos.nach_hinten(4.0E-5, 45.953689);
        this.per.elemente[i].isos.nach_hinten(0.0019, 47.952532);
        this.per.elemente[++i].elekneg = 1.3;
        this.per.elemente[i].name = "Scandium";
        this.per.elemente[i].zeichen = "Sc";
        this.per.elemente[i].isos.nach_hinten(1.0, 44.955914);
        this.per.elemente[++i].elekneg = 1.5;
        this.per.elemente[i].name = "Titan";
        this.per.elemente[i].zeichen = "Ti";
        this.per.elemente[i].isos.nach_hinten(0.08, 45.952633);
        this.per.elemente[i].isos.nach_hinten(0.073, 46.951765);
        this.per.elemente[i].isos.nach_hinten(0.738, 47.947947);
        this.per.elemente[i].isos.nach_hinten(0.055, 48.947871);
        this.per.elemente[i].isos.nach_hinten(0.054, 49.944786);
        this.per.elemente[++i].elekneg = 1.6;
        this.per.elemente[i].name = "Vanadium";
        this.per.elemente[i].zeichen = "V";
        this.per.elemente[i].isos.nach_hinten(0.0025, 49.947161);
        this.per.elemente[i].isos.nach_hinten(0.9975, 50.943963);
        this.per.elemente[++i].elekneg = 1.6;
        this.per.elemente[i].name = "Chrom";
        this.per.elemente[i].zeichen = "Cr";
        this.per.elemente[i].isos.nach_hinten(0.0435, 49.946046);
        this.per.elemente[i].isos.nach_hinten(0.8379, 51.94051);
        this.per.elemente[i].isos.nach_hinten(0.095, 52.940651);
        this.per.elemente[i].isos.nach_hinten(0.0236, 53.938882);
        this.per.elemente[++i].elekneg = 1.5;
        this.per.elemente[i].name = "Mangan";
        this.per.elemente[i].zeichen = "Mn";
        this.per.elemente[i].isos.nach_hinten(1.0, 54.938046);
        this.per.elemente[++i].elekneg = 1.8;
        this.per.elemente[i].name = "Eisen";
        this.per.elemente[i].zeichen = "Fe";
        this.per.elemente[i].isos.nach_hinten(0.058, 53.939612);
        this.per.elemente[i].isos.nach_hinten(0.9172, 55.934939);
        this.per.elemente[i].isos.nach_hinten(0.022, 56.935396);
        this.per.elemente[i].isos.nach_hinten(0.0028, 57.933278);
        this.per.elemente[++i].elekneg = 1.8;
        this.per.elemente[i].name = "Cobalt";
        this.per.elemente[i].zeichen = "Co";
        this.per.elemente[i].isos.nach_hinten(1.0, 58.933198);
        this.per.elemente[++i].elekneg = 1.8;
        this.per.elemente[i].name = "Nickel";
        this.per.elemente[i].zeichen = "Ni";
        this.per.elemente[i].isos.nach_hinten(0.6827, 57.935347);
        this.per.elemente[i].isos.nach_hinten(0.261, 59.930789);
        this.per.elemente[i].isos.nach_hinten(0.0113, 60.931058);
        this.per.elemente[i].isos.nach_hinten(0.0359, 61.928346);
        this.per.elemente[i].isos.nach_hinten(0.0091, 63.927968);
        this.per.elemente[++i].elekneg = 1.9;
        this.per.elemente[i].name = "Kupfer";
        this.per.elemente[i].zeichen = "Cu";
        this.per.elemente[i].isos.nach_hinten(0.6917, 62.929599);
        this.per.elemente[i].isos.nach_hinten(0.3083, 64.927792);
        this.per.elemente[++i].elekneg = 1.6;
        this.per.elemente[i].name = "Zink";
        this.per.elemente[i].zeichen = "Zn";
        this.per.elemente[i].isos.nach_hinten(0.486, 63.929145);
        this.per.elemente[i].isos.nach_hinten(0.279, 65.926035);
        this.per.elemente[i].isos.nach_hinten(0.041, 66.927129);
        this.per.elemente[i].isos.nach_hinten(0.188, 67.924846);
        this.per.elemente[i].isos.nach_hinten(0.006, 69.925325);
        this.per.elemente[++i].elekneg = 1.6;
        this.per.elemente[i].name = "Gallium";
        this.per.elemente[i].zeichen = "Ga";
        this.per.elemente[i].isos.nach_hinten(0.601, 68.925581);
        this.per.elemente[i].isos.nach_hinten(0.399, 70.924701);
        this.per.elemente[++i].elekneg = 1.8;
        this.per.elemente[i].name = "Germanium";
        this.per.elemente[i].zeichen = "Ge";
        this.per.elemente[i].isos.nach_hinten(0.205, 69.92425);
        this.per.elemente[i].isos.nach_hinten(0.274, 71.92208);
        this.per.elemente[i].isos.nach_hinten(0.078, 72.923463);
        this.per.elemente[i].isos.nach_hinten(0.365, 73.921179);
        this.per.elemente[i].isos.nach_hinten(0.078, 75.921403);
        this.per.elemente[++i].elekneg = 2.0;
        this.per.elemente[i].name = "Arsen";
        this.per.elemente[i].zeichen = "As";
        this.per.elemente[i].isos.nach_hinten(1.0, 74.921596);
        this.per.elemente[++i].elekneg = 2.4;
        this.per.elemente[i].name = "Selen";
        this.per.elemente[i].zeichen = "Se";
        this.per.elemente[i].isos.nach_hinten(0.009, 73.922477);
        this.per.elemente[i].isos.nach_hinten(0.09, 75.919207);
        this.per.elemente[i].isos.nach_hinten(0.076, 76.919908);
        this.per.elemente[i].isos.nach_hinten(0.235, 77.917304);
        this.per.elemente[i].isos.nach_hinten(0.496, 79.916521);
        this.per.elemente[i].isos.nach_hinten(0.094, 81.916709);
        this.per.elemente[++i].elekneg = 2.8;
        this.per.elemente[i].name = "Brom";
        this.per.elemente[i].zeichen = "Br";
        this.per.elemente[i].isos.nach_hinten(0.5069, 78.918336);
        this.per.elemente[i].isos.nach_hinten(0.4931, 80.91629);
        this.per.elemente[++i].elekneg = 0.0;
        this.per.elemente[i].name = "Krypton";
        this.per.elemente[i].zeichen = "Kr";
        this.per.elemente[i].isos.nach_hinten(0.0035, 77.920397);
        this.per.elemente[i].isos.nach_hinten(0.0225, 79.916375);
        this.per.elemente[i].isos.nach_hinten(0.116, 81.913483);
        this.per.elemente[i].isos.nach_hinten(0.115, 82.914134);
        this.per.elemente[i].isos.nach_hinten(0.57, 83.911506);
        this.per.elemente[i].isos.nach_hinten(0.173, 85.910614);
        this.per.elemente[++i].elekneg = 0.8;
        this.per.elemente[i].name = "Rubidium";
        this.per.elemente[i].zeichen = "Rb";
        this.per.elemente[i].isos.nach_hinten(0.7217, 84.9118);
        this.per.elemente[i].isos.nach_hinten(0.2784, 86.909184);
        this.per.elemente[++i].elekneg = 1.0;
        this.per.elemente[i].name = "Strontium";
        this.per.elemente[i].zeichen = "Sr";
        this.per.elemente[i].isos.nach_hinten(0.0056, 83.913428);
        this.per.elemente[i].isos.nach_hinten(0.0986, 85.909273);
        this.per.elemente[i].isos.nach_hinten(0.07, 86.908902);
        this.per.elemente[i].isos.nach_hinten(0.8258, 87.905625);
        this.per.elemente[++i].elekneg = 1.3;
        this.per.elemente[i].name = "Yttrium";
        this.per.elemente[i].zeichen = "Y";
        this.per.elemente[i].isos.nach_hinten(1.0, 88.905856);
        this.per.elemente[++i].elekneg = 1.4;
        this.per.elemente[i].name = "Zirconium";
        this.per.elemente[i].zeichen = "Zr";
        this.per.elemente[i].isos.nach_hinten(0.5145, 89.904708);
        this.per.elemente[i].isos.nach_hinten(0.1127, 90.905644);
        this.per.elemente[i].isos.nach_hinten(0.1717, 91.905039);
        this.per.elemente[i].isos.nach_hinten(0.1733, 93.906319);
        this.per.elemente[i].isos.nach_hinten(0.0278, 95.908272);
        this.per.elemente[++i].elekneg = 1.6;
        this.per.elemente[i].name = "Niob";
        this.per.elemente[i].zeichen = "Nb";
        this.per.elemente[i].isos.nach_hinten(1.0, 92.906378);
        this.per.elemente[++i].elekneg = 1.8;
        this.per.elemente[i].name = "Molybd\u00e4n";
        this.per.elemente[i].zeichen = "Mo";
        this.per.elemente[i].isos.nach_hinten(0.1484, 91.906809);
        this.per.elemente[i].isos.nach_hinten(0.0925, 93.905086);
        this.per.elemente[i].isos.nach_hinten(0.1592, 94.905838);
        this.per.elemente[i].isos.nach_hinten(0.1668, 95.904676);
        this.per.elemente[i].isos.nach_hinten(0.0955, 96.906018);
        this.per.elemente[i].isos.nach_hinten(0.2413, 97.905405);
        this.per.elemente[i].isos.nach_hinten(0.0963, 99.907473);
        ++i;
        this.per.elemente[++i].elekneg = 2.2;
        this.per.elemente[i].name = "Ruthenium";
        this.per.elemente[i].zeichen = "Ru";
        this.per.elemente[i].isos.nach_hinten(0.0552, 95.907596);
        this.per.elemente[i].isos.nach_hinten(0.0188, 97.905287);
        this.per.elemente[i].isos.nach_hinten(0.127, 98.905937);
        this.per.elemente[i].isos.nach_hinten(0.126, 99.904218);
        this.per.elemente[i].isos.nach_hinten(0.17, 100.905581);
        this.per.elemente[i].isos.nach_hinten(0.316, 101.904348);
        this.per.elemente[i].isos.nach_hinten(0.187, 103.905422);
        this.per.elemente[++i].elekneg = 2.2;
        this.per.elemente[i].name = "Rhodium";
        this.per.elemente[i].zeichen = "Rh";
        this.per.elemente[i].isos.nach_hinten(1.0, 101.905503);
        this.per.elemente[++i].elekneg = 2.2;
        this.per.elemente[i].name = "Palladium";
        this.per.elemente[i].zeichen = "Pd";
        this.per.elemente[i].isos.nach_hinten(0.0102, 101.905609);
        this.per.elemente[i].isos.nach_hinten(0.1114, 103.904026);
        this.per.elemente[i].isos.nach_hinten(0.2233, 104.905075);
        this.per.elemente[i].isos.nach_hinten(0.2733, 105.903475);
        this.per.elemente[i].isos.nach_hinten(0.2646, 107.903894);
        this.per.elemente[i].isos.nach_hinten(0.1172, 109.905169);
        this.per.elemente[++i].elekneg = 1.9;
        this.per.elemente[i].name = "Silber";
        this.per.elemente[i].zeichen = "Ag";
        this.per.elemente[i].isos.nach_hinten(0.5184, 106.905095);
        this.per.elemente[i].isos.nach_hinten(0.4816, 108.904754);
        this.per.elemente[++i].elekneg = 1.7;
        this.per.elemente[i].name = "Cadmium";
        this.per.elemente[i].zeichen = "Cd";
        this.per.elemente[i].isos.nach_hinten(0.0125, 105.906461);
        this.per.elemente[i].isos.nach_hinten(0.0089, 107.904176);
        this.per.elemente[i].isos.nach_hinten(0.1249, 109.903007);
        this.per.elemente[i].isos.nach_hinten(0.128, 110.904182);
        this.per.elemente[i].isos.nach_hinten(0.2413, 111.902761);
        this.per.elemente[i].isos.nach_hinten(0.1222, 112.904401);
        this.per.elemente[i].isos.nach_hinten(0.2873, 113.903361);
        this.per.elemente[i].isos.nach_hinten(0.0749, 115.904758);
        this.per.elemente[++i].elekneg = 1.7;
        this.per.elemente[i].name = "Indium";
        this.per.elemente[i].zeichen = "In";
        this.per.elemente[i].isos.nach_hinten(0.043, 112.904056);
        this.per.elemente[i].isos.nach_hinten(0.957, 114.903875);
        this.per.elemente[++i].elekneg = 1.8;
        this.per.elemente[i].name = "Zinn";
        this.per.elemente[i].zeichen = "Sn";
        this.per.elemente[i].isos.nach_hinten(0.0097, 111.904826);
        this.per.elemente[i].isos.nach_hinten(0.0065, 113.902784);
        this.per.elemente[i].isos.nach_hinten(0.0036, 114.903348);
        this.per.elemente[i].isos.nach_hinten(0.147, 115.901744);
        this.per.elemente[i].isos.nach_hinten(0.077, 116.902954);
        this.per.elemente[i].isos.nach_hinten(0.243, 117.901607);
        this.per.elemente[i].isos.nach_hinten(0.086, 118.90331);
        this.per.elemente[i].isos.nach_hinten(0.324, 119.902199);
        this.per.elemente[i].isos.nach_hinten(0.046, 121.90344);
        this.per.elemente[i].isos.nach_hinten(0.056, 123.905271);
        this.per.elemente[++i].elekneg = 1.9;
        this.per.elemente[i].name = "Antimon";
        this.per.elemente[i].zeichen = "Sb";
        this.per.elemente[i].isos.nach_hinten(0.573, 120.903824);
        this.per.elemente[i].isos.nach_hinten(0.427, 122.904222);
        this.per.elemente[++i].elekneg = 2.1;
        this.per.elemente[i].name = "Tellur";
        this.per.elemente[i].zeichen = "Te";
        this.per.elemente[i].isos.nach_hinten(9.0E-5, 119.904048);
        this.per.elemente[i].isos.nach_hinten(0.026, 121.903055);
        this.per.elemente[i].isos.nach_hinten(0.0091, 122.904278);
        this.per.elemente[i].isos.nach_hinten(0.0482, 123.902825);
        this.per.elemente[i].isos.nach_hinten(0.0714, 124.904435);
        this.per.elemente[i].isos.nach_hinten(0.1895, 125.90331);
        this.per.elemente[i].isos.nach_hinten(0.3169, 127.904464);
        this.per.elemente[i].isos.nach_hinten(0.338, 129.906229);
        this.per.elemente[++i].elekneg = 2.5;
        this.per.elemente[i].name = "Iod";
        this.per.elemente[i].zeichen = "I";
        this.per.elemente[i].isos.nach_hinten(1.0, 126.904477);
        this.per.elemente[++i].elekneg = 0.0;
        this.per.elemente[i].name = "Xenon";
        this.per.elemente[i].zeichen = "Xe";
        this.per.elemente[i].isos.nach_hinten(0.001, 123.905894);
        this.per.elemente[i].isos.nach_hinten(9.0E-4, 125.904281);
        this.per.elemente[i].isos.nach_hinten(0.0191, 127.903531);
        this.per.elemente[i].isos.nach_hinten(0.264, 128.90478);
        this.per.elemente[i].isos.nach_hinten(0.041, 129.90351);
        this.per.elemente[i].isos.nach_hinten(0.212, 130.905076);
        this.per.elemente[i].isos.nach_hinten(0.269, 131.904148);
        this.per.elemente[i].isos.nach_hinten(0.104, 133.905395);
        this.per.elemente[i].isos.nach_hinten(0.089, 135.907219);
        this.per.elemente[++i].elekneg = 0.7;
        this.per.elemente[i].name = "Caesium";
        this.per.elemente[i].zeichen = "Cs";
        this.per.elemente[i].isos.nach_hinten(1.0, 132.905433);
        this.per.elemente[++i].elekneg = 0.9;
        this.per.elemente[i].name = "Barium";
        this.per.elemente[i].zeichen = "Ba";
        this.per.elemente[i].isos.nach_hinten(0.0011, 129.906277);
        this.per.elemente[i].isos.nach_hinten(0.001, 131.905042);
        this.per.elemente[i].isos.nach_hinten(0.0242, 133.90449);
        this.per.elemente[i].isos.nach_hinten(0.0659, 134.905665);
        this.per.elemente[i].isos.nach_hinten(0.0785, 135.905816);
        this.per.elemente[i].isos.nach_hinten(0.1123, 136.905816);
        this.per.elemente[i].isos.nach_hinten(0.717, 137.905236);
        this.per.elemente[++i].elekneg = 1.1;
        this.per.elemente[i].name = "Lanthan";
        this.per.elemente[i].zeichen = "La";
        this.per.elemente[i].isos.nach_hinten(9.0E-4, 137.907114);
        this.per.elemente[i].isos.nach_hinten(0.9991, 138.906355);
        this.per.elemente[++i].elekneg = 1.1;
        this.per.elemente[i].name = "Cer";
        this.per.elemente[i].zeichen = "Ce";
        this.per.elemente[i].isos.nach_hinten(0.0019, 135.90714);
        this.per.elemente[i].isos.nach_hinten(0.0025, 137.905996);
        this.per.elemente[i].isos.nach_hinten(0.8848, 139.905442);
        this.per.elemente[i].isos.nach_hinten(0.1108, 141.909249);
        this.per.elemente[++i].elekneg = 1.1;
        this.per.elemente[i].name = "Praseodym";
        this.per.elemente[i].zeichen = "Pr";
        this.per.elemente[i].isos.nach_hinten(1.0, 140.907657);
        this.per.elemente[++i].elekneg = 1.2;
        this.per.elemente[i].name = "Neodym";
        this.per.elemente[i].zeichen = "Nd";
        this.per.elemente[i].isos.nach_hinten(0.2713, 141.907731);
        this.per.elemente[i].isos.nach_hinten(0.1218, 142.909823);
        this.per.elemente[i].isos.nach_hinten(0.238, 143.910096);
        this.per.elemente[i].isos.nach_hinten(0.083, 144.912582);
        this.per.elemente[i].isos.nach_hinten(0.1719, 145.913126);
        this.per.elemente[i].isos.nach_hinten(0.0576, 147.916901);
        this.per.elemente[i].isos.nach_hinten(0.0564, 149.9209);
        ++i;
        this.per.elemente[++i].elekneg = 1.2;
        this.per.elemente[i].name = "Samarium";
        this.per.elemente[i].zeichen = "Sm";
        this.per.elemente[i].isos.nach_hinten(0.031, 143.912009);
        this.per.elemente[i].isos.nach_hinten(0.15, 146.914907);
        this.per.elemente[i].isos.nach_hinten(0.113, 147.914832);
        this.per.elemente[i].isos.nach_hinten(0.138, 148.917193);
        this.per.elemente[i].isos.nach_hinten(0.074, 149.917285);
        this.per.elemente[i].isos.nach_hinten(0.257, 151.919741);
        this.per.elemente[i].isos.nach_hinten(0.227, 153.922218);
        this.per.elemente[++i].elekneg = 1.2;
        this.per.elemente[i].name = "Europium";
        this.per.elemente[i].zeichen = "Eu";
        this.per.elemente[i].isos.nach_hinten(0.478, 150.91986);
        this.per.elemente[i].isos.nach_hinten(0.522, 152.921243);
        this.per.elemente[++i].elekneg = 1.1;
        this.per.elemente[i].name = "Gadolinium";
        this.per.elemente[i].zeichen = "Gd";
        this.per.elemente[i].isos.nach_hinten(0.002, 151.919803);
        this.per.elemente[i].isos.nach_hinten(0.0218, 153.920876);
        this.per.elemente[i].isos.nach_hinten(0.148, 154.822629);
        this.per.elemente[i].isos.nach_hinten(0.2047, 155.92213);
        this.per.elemente[i].isos.nach_hinten(0.1565, 156.923967);
        this.per.elemente[i].isos.nach_hinten(0.2484, 157.924111);
        this.per.elemente[i].isos.nach_hinten(0.2186, 159.927061);
        this.per.elemente[++i].elekneg = 1.2;
        this.per.elemente[i].name = "Terbium";
        this.per.elemente[i].zeichen = "Tb";
        this.per.elemente[i].isos.nach_hinten(1.0, 158.92535);
        this.per.elemente[++i].elekneg = 1.2;
        this.per.elemente[i].name = "Dysprosium";
        this.per.elemente[i].zeichen = "Dy";
        this.per.elemente[i].isos.nach_hinten(6.0E-4, 155.924287);
        this.per.elemente[i].isos.nach_hinten(0.001, 157.924412);
        this.per.elemente[i].isos.nach_hinten(0.0234, 159.925203);
        this.per.elemente[i].isos.nach_hinten(0.189, 160.926939);
        this.per.elemente[i].isos.nach_hinten(0.255, 161.926805);
        this.per.elemente[i].isos.nach_hinten(0.249, 162.928737);
        this.per.elemente[i].isos.nach_hinten(0.282, 163.929183);
        this.per.elemente[++i].elekneg = 1.2;
        this.per.elemente[i].name = "Holmium";
        this.per.elemente[i].zeichen = "Ho";
        this.per.elemente[i].isos.nach_hinten(1.0, 164.930332);
        this.per.elemente[++i].elekneg = 1.3;
        this.per.elemente[i].name = "Erbium";
        this.per.elemente[i].zeichen = "Er";
        this.per.elemente[i].isos.nach_hinten(0.0014, 161.928787);
        this.per.elemente[i].isos.nach_hinten(0.0161, 163.929211);
        this.per.elemente[i].isos.nach_hinten(0.336, 165.930305);
        this.per.elemente[i].isos.nach_hinten(0.2295, 166.932061);
        this.per.elemente[i].isos.nach_hinten(0.268, 167.932383);
        this.per.elemente[i].isos.nach_hinten(0.149, 169.935476);
        this.per.elemente[++i].elekneg = 1.2;
        this.per.elemente[i].name = "Thulium";
        this.per.elemente[i].zeichen = "Tm";
        this.per.elemente[i].isos.nach_hinten(1.0, 168.934225);
        this.per.elemente[++i].elekneg = 1.1;
        this.per.elemente[i].name = "Ytterbium";
        this.per.elemente[i].zeichen = "Yb";
        this.per.elemente[i].isos.nach_hinten(0.0013, 167.933908);
        this.per.elemente[i].isos.nach_hinten(0.0305, 169.934774);
        this.per.elemente[i].isos.nach_hinten(0.143, 170.936338);
        this.per.elemente[i].isos.nach_hinten(0.219, 171.936393);
        this.per.elemente[i].isos.nach_hinten(0.1612, 172.938222);
        this.per.elemente[i].isos.nach_hinten(0.318, 173.938873);
        this.per.elemente[i].isos.nach_hinten(0.127, 175.942576);
        this.per.elemente[++i].elekneg = 1.2;
        this.per.elemente[i].name = "Lutetium";
        this.per.elemente[i].zeichen = "Lu";
        this.per.elemente[i].isos.nach_hinten(0.974, 174.940785);
        this.per.elemente[i].isos.nach_hinten(0.026, 175.942694);
        this.per.elemente[++i].elekneg = 1.3;
        this.per.elemente[i].name = "Hafnium";
        this.per.elemente[i].zeichen = "Hf";
        this.per.elemente[i].isos.nach_hinten(0.0016, 173.940065);
        this.per.elemente[i].isos.nach_hinten(0.052, 175.94142);
        this.per.elemente[i].isos.nach_hinten(0.186, 176.943233);
        this.per.elemente[i].isos.nach_hinten(0.271, 177.94371);
        this.per.elemente[i].isos.nach_hinten(0.1374, 178.945827);
        this.per.elemente[i].isos.nach_hinten(0.352, 179.946561);
        this.per.elemente[++i].elekneg = 1.5;
        this.per.elemente[i].name = "Tantal";
        this.per.elemente[i].zeichen = "Ta";
        this.per.elemente[i].isos.nach_hinten(1.2E-4, 179.947489);
        this.per.elemente[i].isos.nach_hinten(0.9999, 180.948014);
        this.per.elemente[++i].elekneg = 1.7;
        this.per.elemente[i].name = "Wolfram";
        this.per.elemente[i].zeichen = "W";
        this.per.elemente[i].isos.nach_hinten(0.0013, 179.946727);
        this.per.elemente[i].isos.nach_hinten(0.263, 181.948225);
        this.per.elemente[i].isos.nach_hinten(0.143, 182.950245);
        this.per.elemente[i].isos.nach_hinten(0.3067, 183.950953);
        this.per.elemente[i].isos.nach_hinten(0.236, 185.954377);
        this.per.elemente[++i].elekneg = 1.9;
        this.per.elemente[i].name = "Rhenium";
        this.per.elemente[i].zeichen = "Re";
        this.per.elemente[i].isos.nach_hinten(0.374, 184.952977);
        this.per.elemente[i].isos.nach_hinten(0.626, 186.955765);
        this.per.elemente[++i].elekneg = 2.2;
        this.per.elemente[i].name = "Osmium";
        this.per.elemente[i].zeichen = "Os";
        this.per.elemente[i].isos.nach_hinten(2.0E-4, 183.952514);
        this.per.elemente[i].isos.nach_hinten(0.0158, 185.953852);
        this.per.elemente[i].isos.nach_hinten(0.016, 186.955762);
        this.per.elemente[i].isos.nach_hinten(0.133, 187.95585);
        this.per.elemente[i].isos.nach_hinten(0.161, 188.958156);
        this.per.elemente[i].isos.nach_hinten(0.264, 189.958455);
        this.per.elemente[i].isos.nach_hinten(0.41, 191.961487);
        this.per.elemente[++i].elekneg = 2.2;
        this.per.elemente[i].name = "Iridium";
        this.per.elemente[i].zeichen = "Ir";
        this.per.elemente[i].isos.nach_hinten(0.373, 190.960603);
        this.per.elemente[i].isos.nach_hinten(0.627, 192.962942);
        this.per.elemente[++i].elekneg = 2.2;
        this.per.elemente[i].name = "Platin";
        this.per.elemente[i].zeichen = "Pt";
        this.per.elemente[i].isos.nach_hinten(1.0E-4, 189.959937);
        this.per.elemente[i].isos.nach_hinten(0.0079, 191.961049);
        this.per.elemente[i].isos.nach_hinten(0.329, 193.962679);
        this.per.elemente[i].isos.nach_hinten(0.338, 194.964785);
        this.per.elemente[i].isos.nach_hinten(0.253, 195.964947);
        this.per.elemente[i].isos.nach_hinten(0.072, 197.967879);
        this.per.elemente[++i].elekneg = 2.4;
        this.per.elemente[i].name = "Gold";
        this.per.elemente[i].zeichen = "Au";
        this.per.elemente[i].isos.nach_hinten(1.0, 196.96656);
        this.per.elemente[++i].elekneg = 1.9;
        this.per.elemente[i].name = "Quecksilber";
        this.per.elemente[i].zeichen = "Hg";
        this.per.elemente[i].isos.nach_hinten(0.0015, 195.965812);
        this.per.elemente[i].isos.nach_hinten(0.101, 197.96676);
        this.per.elemente[i].isos.nach_hinten(0.17, 198.968269);
        this.per.elemente[i].isos.nach_hinten(0.231, 199.968316);
        this.per.elemente[i].isos.nach_hinten(0.132, 200.970293);
        this.per.elemente[i].isos.nach_hinten(0.2965, 201.970632);
        this.per.elemente[i].isos.nach_hinten(0.068, 203.973481);
        this.per.elemente[++i].elekneg = 1.8;
        this.per.elemente[i].name = "Thallium";
        this.per.elemente[i].zeichen = "Tl";
        this.per.elemente[i].isos.nach_hinten(0.2952, 202.972336);
        this.per.elemente[i].isos.nach_hinten(0.7048, 204.97441);
        this.per.elemente[++i].elekneg = 1.8;
        this.per.elemente[i].name = "Blei";
        this.per.elemente[i].zeichen = "Pb";
        this.per.elemente[i].isos.nach_hinten(0.014, 203.973037);
        this.per.elemente[i].isos.nach_hinten(0.241, 205.974455);
        this.per.elemente[i].isos.nach_hinten(0.221, 206.975885);
        this.per.elemente[i].isos.nach_hinten(0.524, 207.976641);
        this.per.elemente[++i].elekneg = 1.9;
        this.per.elemente[i].name = "Bismut";
        this.per.elemente[i].zeichen = "Bi";
        this.per.elemente[i].isos.nach_hinten(1.0, 208.980388);
        ++i;
        ++i;
        ++i;
        ++i;
        ++i;
        ++i;
        this.per.elemente[++i].elekneg = 1.3;
        this.per.elemente[i].name = "Thorium";
        this.per.elemente[i].zeichen = "Th";
        this.per.elemente[i].isos.nach_hinten(1.0, 232.038054);
        ++i;
        this.per.elemente[++i].elekneg = 1.7;
        this.per.elemente[i].name = "Uran";
        this.per.elemente[i].zeichen = "U";
        this.per.elemente[i].isos.nach_hinten(6.0E-6, 234.040947);
        this.per.elemente[i].isos.nach_hinten(0.0072, 235.043925);
        this.per.elemente[i].isos.nach_hinten(0.9927, 238.050786);
    }
}

